/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.LinuxControllers;
import net.java.games.input.LinuxEventDevice;
import net.java.games.input.Rumbler;

final class LinuxAbstractController
extends AbstractController {
    private final Controller.PortType port;
    private final LinuxEventDevice device;
    private final Controller.Type type;

    protected LinuxAbstractController(LinuxEventDevice device, Component[] components, Controller[] children2, Rumbler[] rumblers, Controller.Type type) throws IOException {
        super(device.getName(), components, children2, rumblers);
        this.device = device;
        this.port = device.getPortType();
        this.type = type;
    }

    public final Controller.PortType getPortType() {
        return this.port;
    }

    public final void pollDevice() throws IOException {
        this.device.pollKeyStates();
    }

    protected final boolean getNextDeviceEvent(Event event) throws IOException {
        return LinuxControllers.getNextDeviceEvent(event, this.device);
    }

    public Controller.Type getType() {
        return this.type;
    }
}

